<?php  include "../includes/header.php"; ?>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.9/css/jquery.dataTables.min.css">
	<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/1.0.3/css/buttons.dataTables.min.css">
<script src="//code.jquery.com/jquery-1.11.3.min.js"></script>
<script src="https://cdn.datatables.net/1.10.9/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.0.3/js/dataTables.buttons.min.js"></script>
<script src="//cdn.datatables.net/buttons/1.0.3/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/select/1.0.1/js/dataTables.select.min.js"></script>

<style>
    .container {
        padding: 15px;
        background: var(--dark-blue);
        border-radius: 5px;
        color: var(--text-color);
    }
    form input {
        padding: 10px; 
        border-radius: 3px;
        border: 1px solid var(--hover);
        display: block;
        width: 100%;
        background: var(--primary);
        color: var(--text-color);
        margin: 10px 0;
        font-size: 12px;
    }
    form label {
        margin: 20px 0;
        font-size: 14px;
    }
    form button {
        background: dodgerblue;
        padding: 9px 15px;
        display: flex;
        align-items: center;
        color: white;
        border: 1px solid dodgerblue;
        border-radius: 3px;
        margin: 5px 0;
    }
    #dol {
        position: absolute; 
        right: 40px; 
        transform: translateY(-38px); 
        z-index: 1; 
        width: 24px; 
        height: 23px; 
        border-radius: 50%; 
        background: var(--text-color); 
        color: var(--text);
    }
    #container-table {
        width: 100%;
        overflow-x: scroll;
    }
    #container-table::-webkit-scrollbar {
        background: transparent;
        width: 0;
        height: 0;
    }
    table {
        border-collapse: collapse;
        border-radius: 5px;
        width: 100%;
        /* border: 1px solid var(--text); */
    }
	th, td {
		background: var(--dark);
        font-size: 13px;
        color: var(--text-color);
		border: 1px solid var(--text);
        text-transform:  capitalize;
        text-align: center;
	}
    .pending {
        background: #3a1716; 
        color: #e01a1a;
        padding: 5px;
        font-size: 10px;
        text-transform: lowercase;
        border-radius: 3px;
    }

    .success {
        background: #163A3A; 
        color: #1AE0A1;
        padding: 3px;
        text-transform: lowercase;
        border-radius: 3px;
    }

    @media screen and (min-width: 768px) {}

    @media screen and (min-width: 1200px) {}
</style>
<style>
        @media screen and (min-width: 768px) {
            .fixed-width {
                width: 100%;
                margin: 0 0%;
            }
            
            .side-panel-right {
                display: none;
                width: 30%;
            }
        }

        @media screen and (min-width: 1200px) {
            .fixed-width {
                width: 80%;
                transform: translateX(5%);
                margin: 0 15%;
            }

            .side-panel-left {
                width: 20%;
                display: block;
            }
        }
    </style>


 <div class="container">
     <div id='container-table'>
 <table id="example" class="display" style='background: var(--dark)' cellspacing="0" width="100%">
					<thead>
						<tr>
							<th style='width: 14px'>#</th>
							<th>TYPE</th>
							<th>AMOUNT</th>
							<th>STATUS</th>
							<th>S/L</th>
							<th>T/P</th>
							<th>PROFIT</th>
							<th>LOSS</th>
							<th>PAIR</th>
							<th>DATE</th>
						</tr>
					</thead>

					<tbody>
                        <?php 
                            $i = 1;
                            $sql = "SELECT * FROM transaction WHERE transaction_user_id = '$user_id' AND transaction_type = 'trade'";
                            $result = $connection->query($sql);
                            while ($row = $result->fetch_assoc()) {
                                $transaction_status = $row['transaction_status'];
                                $transaction_amount = $row['transaction_amount'];
                                $transaction_date = $row['transaction_date'];
                                $transaction_type = $row['type_exe'];                        
                                $type_exe         = $row['type_exe'];                        
                                $stop_loss        = $row['stop_loss'];                        
                                $take_profit      = $row['take_profit'];                        
                                $pair_trade       = $row['pair_trade'];                        
                                $trade_won        = $row['trade_won'];                        
                                $trade_loss       = $row['trade_loss'];                        
                        ?>
							<tr>
                                <td style='background: var(--dark)'><?php echo $i++?></td>
                                <td><?php echo $transaction_type?></td>
                                <td>$<?php echo number_format($transaction_amount, 2)?></td>
                                <td>
                                    <?php 
                                        if ($transaction_status == "pending") {
                                            echo "<span class='pending'>pending</span>";
                                        }else if ($transaction_status == "success") {
                                            echo "<span class='success'>approved</span>";
                                        }else if ($transaction_status == "won") {
                                            echo "<span class='success' style='padding: 3px 12px'>won</span>";
                                        }else if ($transaction_status == "loss") {
                                            echo "<span class='pending'>loss</span>";
                                        }
                                    ?>
                                </td>
                                <td><?php echo $stop_loss?></td>
                                <td><?php echo $take_profit?></td>
                                <td><?php echo $trade_won?></td>
                                <td><?php echo $trade_loss?></td>
                                <td><?php echo $pair_trade?></td>
                                <td><?php echo $transaction_date?></td>
							</tr>
                        <?php }?>
					</tbody>
				</table>
                </div>
 </div>


<script>
   function applyDataTable(){
  
  $('#example').DataTable( {
		dom: 'Bfrtip',
		buttons: [
			{
				extend: 'print',
				text: 'Print all'
			},
			{
				extend: 'print',
				text: 'Print current page',
				exportOptions: {
					modifier: {
						  page: 'current'
					}
				}
			}
		],
		select: true
	} );
  
  
}


$(document).ready(function() {
  $('#trigger-update').click(function(){
      $('#example').DataTable().destroy();
    
      setTimeout(function(){
        applyDataTable();
      },2000);
       
  });
  
  applyDataTable();
	
} );


</script>

<?php  include "../includes/footer.php"; ?>
